using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
 
using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.Util;
using Android.Locations;
 
namespace ScratchStartOnBoot
{
    [Service]
    public class LocationService : Service, 
        Android.Locations.ILocationListener
    {
        private NotificationManager nm;
        private IBinder binder;
        string bestProvider;
 
        public LocationService()
        {
            binder = new LocalBinder(this);
        }
 
        public class LocalBinder : Binder
        {
            LocationService self;
 
            public LocalBinder(LocationService self)
            {
                this.self = self;
            }
 
            public LocationService Service
            {
                get { return self; }
            }
        }
 
        private LocationManager lm;
        public override void OnCreate()
        {
            nm = (NotificationManager)GetSystemService(NotificationService);
            ShowNotification();
            Criteria cr = new Criteria();
            cr.Accuracy = Accuracy.Coarse;
            cr.PowerRequirement = Power.Low;
            cr.AltitudeRequired = false;
            cr.BearingRequired = false;
            cr.SpeedRequired = false;
            cr.CostAllowed = true;
            String serviceString = Context.LocationService;
            lm = (LocationManager)GetSystemService(serviceString);
            bestProvider = lm.GetBestProvider(cr, false);
            Location l = lm.GetLastKnownLocation(bestProvider);
            lm.RequestLocationUpdates(bestProvider, 5000, 100f, this);
        }
 
        public override StartCommandResult OnStartCommand(Intent intent, StartCommandFlags flags, int startId)
        {
            Log.Info("LocationService", "Received start id " + startId + ": " + intent);
            return StartCommandResult.Sticky;
        }
 
        public override void OnDestroy()
        {
            nm.Cancel(Resource.String.local_service_started);
            Toast.MakeText(this, Resource.String.local_service_stopped, ToastLength.Short).Show();
            lm.RemoveUpdates(this);
            StopSelf();
        }
 
        public override IBinder OnBind(Intent intent)
        {
            return binder;
        }
 
        void ShowNotification()
        {
            var text = GetText(Resource.String.local_service_started);
            var notification = new Notification(Resource.Drawable.stat_sample, text, System.Environment.TickCount);
            PendingIntent contentIntent = PendingIntent.GetActivity(this, 0, 
                new Intent(this, typeof(Activity1)), 0);
            notification.SetLatestEventInfo(this, 
                GetText(Resource.String.local_service_label), text, contentIntent);
            nm.Notify(Resource.String.local_service_started, notification);
        }
 
        public void OnLocationChanged(Android.Locations.Location location)
        {        
            var text = "Lat: " + location.Latitude.ToString() +
                " Lon: " + location.Longitude.ToString();
            var notification = new Notification(Resource.Drawable.stat_sample, text, System.Environment.TickCount);
            PendingIntent contentIntent = PendingIntent.GetActivity(this, 0, 
                new Intent(this, typeof(Activity1)), 0);
            notification.SetLatestEventInfo(this, GetText(Resource.String.local_service_label), text, contentIntent);
            nm.Notify(Resource.String.local_service_started, notification);
            Toast.MakeText(this, text, ToastLength.Short).Show();
        }
 
        public void OnProviderDisabled(string provider)
        {
            //throw new NotImplementedException();
        }
 
        public void OnProviderEnabled(string provider)
        {
            //throw new NotImplementedException();
        }
 
        public void OnStatusChanged(string provider, int status, Bundle extras)
        {
            //throw new NotImplementedException();
        }
    }
 
}